<?php
	$TITLE = 'Source Parameter Search';

	$STYLESHEETS = 'rede' . param('style', '0') . '.css';
	$SCRIPTS = 'rede' . param('script', '0') . '.js';
	$STYLES = "
		#steps { 
			list-style:none;
			margin:16px;
			padding:16px;
			background-color: #EEEEEE;
			border:1px solid #CCCCCC;
		}
	";

	include_once $_SERVER['DOCUMENT_ROOT'] . '/template/template.inc.php';
?>

<ol id="steps">
	<li><strong>Step through it</strong></li>
	<li><a href="rede.php">Symantec HTML</a></li>
	<li><a href="rede.php?style=1">Some Style</a></li>
	<li><a href="rede.php?style=2&amp;script=1">Some Features</a></li>
</ol>

<form method="post" action="rede.php" id="sopar">
	<ol class="required">
		<li>
			<fieldset class="datasource">
				<legend>Data Source</legend>
				<ul>
					<li><label class="checkbox"><input type="checkbox" 
						checked="checked" id="datasource_usgs" name="datasource"/>
						USGS</label></li>
					<li><label class="checkbox"><input type="checkbox" 
						checked="checked" id="datasource_harvard" name="datasource"/>
						Harvard</label></li>
					<li><label class="checkbox"><input type="checkbox" 
						checked="checked" id="datasource_other" name="datasource"/>
						Other</label></li>
					<li class="help">Default: All</li>
				</ul>
			</fieldset>
		</li>
		<li>
			<fieldset class="outputformat">
				<legend>Output Format</legend>
				<ul>
					<li><label class="radio"><input type="radio"
						checked="checked" id="outputofrmat_fm" name="outputofrmat" />
						FM</label></li>
					<li><label class="radio"><input type="radio"
						id="outputofrmat_cv" name="outputofrmat" />
						FM CSV</label></li>
					<li><label class="radio"><input type="radio"
						id="outputofrmat_mm" name="outputofrmat" />
						MM</label></li>
					<li><label class="radio"><input type="radio"
						id="outputofrmat_mt" name="outputofrmat" />
						MT</label></li>
					<li class="help">Default: FM</li>
				</ul>
			</fieldset>
		</li>
	</ol>
	<a href="javascript:void(null);" id="optionalparameters"
		>Optional Parameters</a>
	<ul class="optional">
		<li>
			<fieldset class="magnitude">
				<legend>Mw Magnitude</legend>
				<ul>
					<li>
						<label for="mag_min">Minimum</label>
						<input type="text" name="mag_min" id="mag_min" />
					</li>
					<li>
						<label for="mag_max">Maximum</label>
						<input type="text" name="mag_max" id="mag_max" />
					</li>
					<li class="help">Lorem ipsum dolar sit amet</li>
				</ul>
			</fieldset>
		</li>
		<li>
			<fieldset class="depth">
				<legend>Depth (km)</legend>
				<ul>
					<li>
						<label for="depth_min">Minimum</label>
						<input type="text" name="depth_min" id="depth_min" />
					</li>
					<li>
						<label for="depth_max">Maximum</label>
						<input type="text" name="depth_max" id="depth_max" />
					</li>
					<li class="help">Lorem ipsum dolar sit amet</li>
				</ul>
			</fieldset>
		</li>
		<li>
			<fieldset class="latitude">
				<legend>Latitude</legend>
				<ul>
					<li>
						<label for="latitude_min">Minimum</label>
						<input type="text" name="latitude_min" id="latitude_min" />
					</li>
					<li>
						<label for="latitude_max">Maximum</label>
						<input type="text" name="latitude_max" id="latitude_max" />
					</li>
					<li class="help">
						Enter latitudes as decimal degrees between -90&deg; and 
						90&deg;
					</li>
				</ul>
			</fieldset>
		</li>
		<li>
			<fieldset class="longitude">
				<legend>Longitude</legend>
				<ul>
					<li>
						<label for="longitude_min">Minimum</label>
						<input type="text" name="longitude_min" id="longitude_min" />
					</li>
					<li>
						<label for="longitude_max">Maximum</label>
						<input type="text" name="longitude_max" id="longitude_max" />
					</li>
					<li class="help">
						Enter longitudes as decimal degrees between -180&deg; and 
						180&deg;
					</li>
				</ul>
			</fieldset>
		</li>
		<li class="help">
			Input southern latitudes and western longitues as negative numbers.
		</li>
		<li>
			<fieldset class="startdate">
				<legend>Starting Date</legend>
				<ul>
					<li>
						<label for="ds_year">Year</label>
						<input type="text" name="ds_year" id="ds_year" />
					</li>
					<li>
						<label for="ds_month">Month</label>
						<input type="text" name="ds_month" id="ds_month" />
					</li>
					<li>
						<label for="ds_day">Day</label>
						<input type="text" name="ds_day" id="ds_day" />
					</li>
					<li class="help">Lorem ipsum dolar sit amet</li>
				</ul>
			</fieldset>
		</li>
		<li>
			<fieldset class="enddate">
				<legend>Starting Date</legend>
				<ul>
					<li>
						<label for="de_year">Year</label>
						<input type="text" name="de_year" id="de_year" />
					</li>
					<li>
						<label for="de_month">Month</label>
						<input type="text" name="de_month" id="de_month" />
					</li>
					<li>
						<label for="de_day">Day</label>
						<input type="text" name="de_day" id="de_day" />
					</li>
					<li class="help">Lorem ipsum dolar sit amet</li>
				</ul>
			</fieldset>
		</li>
	</ul>
	<input type="submit" name="submit" id="submit" value="Submit"/>
</form>
